<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Website extends Model 
{

    protected $table = 'websites';
    public $timestamps = true;
    protected $fillable = array('website_name', 'website', 'clinic_id', 'profile_id');
    protected $visible = array('website_name', 'website', 'clinic_id', 'profile_id');

    public function clinic()
    {
        return $this->belongsTo('Clinic');
    }

    public function location()
    {
        return $this->belongsTo('Location');
    }

    public function profile()
    {
        return $this->belongsTo('Profile');
    }

}